(function() {
	var _container = $('#laptopTheContainer');
	var _tmpl = $('#lapStatWortkers').html();
	var _init = true;

	$(window).on('hashchange.laptopWorkers', function() {
		$(window).off('resize.laptopWorkers');
		$(window).off('hashchange.laptopWorkers');
	});

	$(window).off('resize.laptopWorkers');
	$(window).on('resize.laptopWorkers', fx);
	fx();

	function fx() {
		$('#lapStatWortkers').css('display', 'none');
		var wWW = _container.width();
		var hHH = _container.height();
		if (_init && wWW <= 100) {
			window.setTimeout(fx, 0);
			return;
		}
		_init = false;
		$('#lapStatWortkers').html(_tmpl);
		$('#lapStatWortkers').css('display', 'block');

		//update on tura changed
		$(window).bind('turaStatusChanged', function(event, status) {
			if (status != 0) {
				//allow fireing
				$('img[worker-id]').css('display', 'inline');
			} else {
				//disallow fireing
				$('img[worker-id]').css('display', 'none');
			}
		});
		$(window).trigger('turaStatusChanged', window.userdata['tura_aktywna']);

		if ($('[tab-worker-id]').length > 1) {
			$('#lista-pracownikow-container').slidesjs({
				width: wWW,
				height: hHH,
				navigation: {
					active: false
				},
				pagination: {
					active: true
				}
			});
		} else $('.slidesjs-navigation').hide(0);

		$('img[worker-id]').click(function() {
			var workerId = $(this).attr('worker-id');
			var mesage = '<div>Czy jesteś pewny(a), że chcesz zwolnić tego pracownika?<br/><br/>' +
				'Tego typu decyzja powinna byc podjęta wspólnie z innymi właścicielami.<br/><br/>' +
				'Stracisz w ten sposób cześć punktów oraz ograniczysz możliwości wykonywania zleceń.</div>';
			if (userdata.plec == 'k')
				mesage = mesage.replace('y(a)', 'a');
			else
				mesage = mesage.replace('(a)', '');
			$(mesage).dialog({
				dialogClass: 'alertDialog',
				title: 'Zwolnij pracownika',
				draggable: false,
				modal: true,
				hide: {
					effect: 'clip',
					duration: 500
				},
				show: {
					effect: 'scale',
					duration: 600
				},
				buttons: [{
					text: 'TAK',
					click: function() {
						var thisDialog = $(this);
						$.ajax({
							type: 'POST',
							url: window.links.studentAjaxFireWorker,
							data: {
								worker_id: workerId
							},
							success: function(data) {
								if (data.error)
									showMessage('Błąd', data.error);
								else {
									//update game panel
									window.updateSidebarPoints(data.punktyFirmy);
									window.updateSidebarRanking(data.rankingFirm);
									//remove worker from computer
									var delay = $('#lista-pracownikow-container [slidesjs-index]').length <= 1 ? 400 : 0;
									$('.slidesjs-pagination-item .active').parent().fadeOut(delay, function() {
										$(this).remove();
									});
									$('[tab-worker-id="' + workerId + '"]').fadeOut(delay, function() {
										$(this).remove();
										//refresh tabs
										if ($('#lista-pracownikow-container').data()['plugin_slidesjs'] != undefined) {
											var tabs = $('#lista-pracownikow-container [slidesjs-index]');
											tabs.each(function(idx, elem) {
												$(elem).attr('slidesjs-index', idx);
											});
											$('#lista-pracownikow-container [data-slidesjs-item]').each(function(idx, elem) {
												$(elem).attr('data-slidesjs-item', idx);
												$(elem).text(idx + 1);
											});
											$('#lista-pracownikow-container').data().plugin_slidesjs.data.total = tabs.length;
											$('#lista-pracownikow-container').data().plugin_slidesjs.data.current--;
											if (tabs.length > 1)
												$('#lista-pracownikow-container .slidesjs-next').click();
											else if (tabs.length == 1) {
												//hide next, previus, paggination
												$('#lista-pracownikow-container .slidesjs-pagination, #lista-pracownikow-container .slidesjs-previous, #lista-pracownikow-container .slidesjs-next').fadeOut();
												$('#lista-pracownikow-container [slidesjs-index="0"]').animate({
													left: 0
												});
											} else {
												$('#lista-pracownikow-container').fadeOut(400, function() {
													$(this).remove();
													$('#lista-pracownikow-none').fadeIn().css('display', 'table');
												});
											}
										} else {
											$('#lista-pracownikow-container').fadeOut(400, function() {
												$(this).remove();
												$('#lista-pracownikow-none').fadeIn().css('display', 'table');
											});
										}
									});
								}
							},
							complete: function() {
								thisDialog.dialog('close');
							},
							error: function(xhr, status, error) {
								showMessage('Błąd', status + ' ' + error);
							}
						});
					}
				}, {
					text: 'Nie',
					click: function() {
						$(this).dialog('close');
					}
				}]
			});

		});

	}

})();
